/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text.rules;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.js.text.rules.JSEscapeSequenceDetector;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;

public class JSEscapeSequenceRule
extends ExtendedWordRule {
    private static final String REGEXP = "\\\\(x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]|37[0-7]?|[4-7][0-7]?|.)";
    private static Pattern PATTERN;

    private static synchronized Pattern getPattern() {
        if (PATTERN == null) {
            PATTERN = Pattern.compile(REGEXP);
        }
        return PATTERN;
    }

    public JSEscapeSequenceRule(IToken token) {
        super((IWordDetector)new JSEscapeSequenceDetector(), token, false);
    }

    protected boolean wordOK(String word, ICharacterScanner scanner) {
        return JSEscapeSequenceRule.getPattern().matcher(word).matches();
    }
}

